#version 130
precision highp float;

uniform vec3 uLightAmb;
uniform vec3 uLightDif;
uniform vec3 uLightSky;

uniform vec4 uMulColor;  // Multiplication color
uniform vec3 uFlagColor; // Flag color
uniform vec3 uAddColor;  // Add color

varying vec3 C; // Input mesh color (vertex or texture later on)
varying vec3 L; // Light
varying vec3 N; // Normal

void main()
{
  vec3 ecNormal = normalize(N);
  float ecDotDirection = max(0.0, dot(ecNormal, L));
  vec3 sunColor = ecDotDirection * uLightDif;

  float ecSkyDirection = max(0.0, dot(ecNormal, vec3(0, 0, 1)));
  vec3 skyColor = ecSkyDirection * uLightSky;

  vec3 envColor = sunColor + uLightAmb + skyColor;

  gl_FragColor = vec4(C * envColor * uMulColor.rgb + uAddColor + uFlagColor * 0.0001, uMulColor.a);
}