#version 130
precision highp float;

uniform vec4 uClipPlane;
uniform vec3 uLightAmb;
uniform vec3 uLightDif;
uniform vec3 uLightSky;
uniform vec3 uFogColor;
uniform vec3 uFowColor;
uniform vec2 uFowScale;
uniform sampler2D uFowTexture;

varying vec3 C;
varying vec3 L;
varying vec3 N;
varying vec3 P;
varying float fogValue;

void main()
{
  /* Discard pixels behind Clipping Plane */
  float clipPos = dot(P, uClipPlane.xyz) + uClipPlane.w;
  if (clipPos < 0.0) {
    discard;
  }

  float fow = texture2D(uFowTexture, P.xy * uFowScale).r;
  
  if (fow <= 0.0) {
    discard;
  }

  vec3 ecNormal = normalize(N);
  float ecDotDirection = max(0.0, dot(ecNormal, L));
  vec3 diffuse = ecDotDirection * uLightDif;
  vec3 light = diffuse + uLightAmb + uLightSky;

  vec3 color = mix(C.rgb * light.rgb, uFogColor, fogValue);
  //color = mix(uFowColor, color, fow);

  gl_FragColor = vec4(color, fow);
}