precision highp float;

attribute vec3 vPosition;
attribute vec3 vaNormal;
attribute vec3 vaColor;
attribute float vaBoneId;

uniform mat4 mProj;
uniform mat4 mView;
uniform mat4 mBones[16];
uniform vec3 uLightPos;

varying vec3 C; // Color
varying vec3 L; // Light
varying vec3 N; // Normal

void main()
{
   C = vaColor;
   L = normalize(vec3(mView * vec4(uLightPos, 0.0)));

   int boneId = int(vaBoneId);

   // Not sure why exactly, but this order of multiplications works as required
   vec3 newNormal = vaNormal * mat3(mBones[boneId]);
   N = normalize(mat3(mView) * newNormal);

   vec4 vert = vec4(vPosition, 1.0) * mBones[boneId];
   vert.w = 1.0;

   gl_Position = mProj * mView * vert;
}