precision highp float;

attribute vec3 vPosition;
attribute vec3 vaNormal;
attribute vec3 vaColor;

uniform mat4  mProj;
uniform mat4  mView;
uniform vec3  uLightPos;
uniform vec3  uEyePosition;
uniform float uFogA;
uniform float uFogB;

varying vec3 C; // Color
varying vec3 L; // Light
varying vec3 N; // Normal
varying vec3 P; // Position
varying float fogValue;

void main()
{
  C = vaColor;
  L = normalize(vec3(mView * vec4(uLightPos, 0.0)));
  N = normalize(vec3(mView * vec4(vaNormal, 0.0)));
  P = vPosition;

  // Fog
  vec3 rayDir = P - uEyePosition;
  float distance = length(rayDir);
  rayDir = normalize(rayDir);
  fogValue = uFogA * exp(-uEyePosition.z * uFogB) * (1.0 - exp(-distance * rayDir.z * uFogB)) / rayDir.z;
  fogValue = clamp(fogValue, 0.0, 1.0);

  gl_Position = mProj * mView * vec4(vPosition, 1.0);
} 
