#version 130
precision highp float;

uniform vec4 uClipPlane;
uniform vec3 uLightAmb;
uniform vec3 uLightDif;
uniform vec3 uLightSky;
uniform vec3 uFogColor;
uniform vec3 uFowColor;
uniform vec2 uFowScale;
uniform sampler2D uFowTexture;

varying vec3 C;
varying vec3 L;
varying vec3 N;
varying vec3 P;
varying float fogValue;

const float px = 2 / 1024.0; //UV offset, should be tied with texture resolution. 3 is empirical value that looks goos for 1024

void main()
{
  /* Discard pixels behind Clipping Plane */
  float clipPos = dot(P, uClipPlane.xyz) + uClipPlane.w;
  if (clipPos < 0.0) {
    discard;
  }

  /* Calculate FOW */
  // Sample FOW with 0.5 offset because it is vertice-based, not tile/pixel based
  vec2 uv = (P.xy + vec2(0.5, 0.5)) * uFowScale;

  // Rough FOW
  //float fow = texture2D(uFowTexture, uv).r;

  // Blurred FOW looks much better
  /* Terrain is especially revealing of FOW imperfections, hence we prettify terrain FOW by bluring it */
  float fow = texture2D(uFowTexture, uv).r * 4.0;
  fow += texture2D(uFowTexture, uv + vec2(-px, 0.0)).r;
  fow += texture2D(uFowTexture, uv + vec2(px, 0.0)).r;
  fow += texture2D(uFowTexture, uv + vec2(0.0, -px)).r;
  fow += texture2D(uFowTexture, uv + vec2(0.0, px)).r;
  fow /= 8.0;
  
  if (fow <= 0.0) {
    discard;
  }

  vec3 ecNormal = normalize(N);
  float ecDotDirection = max(0.0, dot(ecNormal, L));
  vec3 diffuse = ecDotDirection * uLightDif;
  vec3 light = diffuse + uLightAmb + uLightSky;

  vec3 color = mix(C.rgb * light.rgb, uFogColor, fogValue);
  color = mix(uFowColor, color, fow);

  gl_FragColor = vec4(color, 1.0);
}