#version 130
precision highp float;

uniform vec3 uLightAmb;
uniform vec3 uLightDif;
uniform vec3 uLightSky;
uniform sampler2D uTexture;
uniform sampler2D uTextureMask;

uniform vec3 uAddColor;  // Add color
uniform vec3 uFlagColor; // Flag color
uniform vec4 uMulColor;  // Multiplication color

varying vec3 C; // Color
varying vec3 L; // Light
varying vec3 N; // Normal
varying vec2 UV; // UV

void main()
{
  vec3 ecNormal = normalize(N);
  float ecDotDirection = max(0.0, dot(ecNormal, L));
  vec3 sunColor = ecDotDirection * uLightDif;

  float ecSkyDirection = max(0.0, dot(ecNormal, vec3(0, 0, 1)));
  vec3 skyColor = ecSkyDirection * uLightSky;

  vec3 envColor = sunColor + uLightAmb + skyColor;

  vec4 tex = texture2D(uTexture, UV);
  vec4 texMask = texture2D(uTextureMask, UV);

  vec3 diffuseColor = C.rgb * mix(tex.rgb, (tex.r+tex.g+tex.b) / 3 * uFlagColor, texMask.r) * uMulColor.rgb + uAddColor;

  vec3 litColor = diffuseColor * envColor;

  gl_FragColor = vec4(litColor, tex.a * uMulColor.a);
}