#version 130
precision highp float;

attribute vec3 vPosition;

uniform mat4  mProj;
uniform mat4  mView;
uniform vec3  uEyePosition;
uniform float uFogA;
uniform float uFogB;
uniform vec3  uLightPos;
uniform float uWaterLevel;

varying float fogValue;
varying vec3  interpolatedVertexObject;
varying vec3  L;

void main()
{
  interpolatedVertexObject = vPosition;
  
  L = normalize(uLightPos);

  /* Fog */
  float a = uFogA;
  float b = uFogB;
  vec3 rayDir = vPosition - uEyePosition;
  float distance = length(rayDir);
  rayDir = normalize(rayDir);
  fogValue = a*exp(-uEyePosition.z*b)*(1.0-exp(-distance*rayDir.z*b))/rayDir.z;
  fogValue = clamp(fogValue, 0.0, 1.0);

  gl_Position = mProj * mView * vec4(vPosition.xy, uWaterLevel, 1.0);
}